package w83b.w83bOperacionesInternas.w83bActas;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bColegiosBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaException;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author 
 *
 */
public class W83bMovimientoActasOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		
		W83bActasBean actasBean = (W83bActasBean)contexto.get("w83bNuevaActaBean");
		actasBean.setColegios((W83bColegiosBean)contexto.get("w83bColegiosBean"));//porque se pierde!!!
		actasBean.setModo((String)contexto.get("modoPantalla"));
		contexto.set("w83bNuevaActaBean", actasBean);	
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		String resultado = (String)contexto.get("w83bResultado");
		
		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.baseDatosLlena", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if("-2".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.actaExistente", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else{
			if(-1!=resultado.indexOf("||errorLibroReg")){	
				contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOkLibroRegistroError");
				resultado = resultado.substring(0,resultado.indexOf("||errorLibroReg"));
			}else{
				contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			}
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			
			contexto.set("codSelecEdicion",resultado);
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
	
	protected void processOIException(Q70ContextoEJIE paramQ70ContextoEJIE, Exception paramException, Q70OperacionInternaErrors paramQ70OperacionInternaErrors)
	throws Exception{
		if(null!=paramException&&null!=((Q70OperacionInternaException)paramException).getPrimaryException() && ((Q70OperacionInternaException)paramException).getPrimaryException() instanceof W83bLibroRegistroException){
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError("error.mensaje.errorRegistroEntrada"));paramQ70ContextoEJIE.get("listaDocs");
		}else{
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError(getConfiguracion().getOiErrorKey()));			
		}
	}
	
}
